//
//  BarReviewViewController.swift
//  BTap
//
//  Created by Chris Ki on 4/1/15.
//  Copyright (c) 2015 Jennifer Wang. All rights reserved.
// 18:00

import UIKit

class BarReviewViewController: UIViewController, UITableViewDataSource, UITableViewDelegate {

    @IBOutlet weak var myTableView: UITableView!
    
    // title labels
    @IBOutlet weak var barnameTitleLabel: UILabel!
    @IBOutlet weak var barAddressLabel: UILabel!
    @IBOutlet weak var barPhoneNumLabel: UILabel!
    var barnameTitleString: String?
    var barAddressString: String?
    var barPhoneNumString: String?
    
    
    var arrayOfUsers: [User] = [User]()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        /*
        if (barnameTitleLabel.text == "") {
            self.barnameTitleLabel.text = "Hoosier Bar"
            self.barAddressLabel.text = "3400 s sare rd"
            self.barPhoneNumLabel.text = "812-340-400"
        }
        else {
            self.barnameTitleLabel.text = barnameTitleString
            self.barAddressLabel.text = barAddressString
            self.barPhoneNumLabel.text = barPhoneNumString
        }
        */
        /*
        self.barnameTitleLabel.text = barnameTitleString
        self.barAddressLabel.text = barAddressString
        self.barPhoneNumLabel.text = barPhoneNumString
        */
        
        self.barnameTitleLabel.text = "Hoosier Bar"
        self.barAddressLabel.text = "3400 s sare rd"
        self.barPhoneNumLabel.text = "812-340-400"
        
        
        // ** important!! don't forget to add this line in the viewDidLoad()
        // nothing will show up in the cell if this line is not added.
        self.setUpUsers()

        // Do any additional setup after loading the view.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    // load the different users to the array of User
    func setUpUsers() {
        
        var writeReviewStored = NSUserDefaults.standardUserDefaults().stringForKey("writeReview2")
        var userNameStored = NSUserDefaults.standardUserDefaults().stringForKey("userName")
        var ratingNumStored = NSUserDefaults.standardUserDefaults().integerForKey("ratingNum2")
        
        var user1 = User(username: "alohaHon", review: "too dark and old looking", rating: 2)
        var user2 = User(username: "Mintx", review: "nice atmosphere", rating: 4)
        var user3 = User(username: "boss", review: "not enough selection of menu", rating: 1)
        var user4 = User(username: userNameStored!, review: writeReviewStored!, rating: ratingNumStored)
        
        arrayOfUsers.append(user1)
        arrayOfUsers.append(user2)
        arrayOfUsers.append(user3)
        //
        arrayOfUsers.append(user4)
    }
    
    // number of cells
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arrayOfUsers.count
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        // it's where what we do something with the cell
        // cell will be a type of custom cell
        let cell: CustomCell = tableView.dequeueReusableCellWithIdentifier("Cell") as CustomCell
        
        /*
        // change cell's background color to purple if it's even num, and orange if odd
        if indexPath.row % 2 == 0 {
        cell.backgroundColor = UIColor.purpleColor()
        }
        else {
        cell.backgroundColor = UIColor.orangeColor()
        }
        */
        let user = arrayOfUsers[indexPath.row]
        // check out User.swift and CustomCell.swift for correct variable names
        cell.setCell(user.username, reviewLabelText: user.review, ratingLabelInt: user.rating)
        
        
        return cell
    }
    
    @IBAction func writeReviewButtonTapped(sender: AnyObject) {
        // --- these lines do better job than ctrl+drg segue
        // blue variable refers to swift file name for that view, and red refers to storyboard ID identifier
        var postRating2ViewController: PostRating2ViewController = self.storyboard?.instantiateViewControllerWithIdentifier("PostRating2ViewController") as PostRating2ViewController
        
        self.presentViewController(postRating2ViewController, animated: true, completion: nil)
        // ---
    }
    
    
    @IBAction func beerListButtonTapped(sender: AnyObject) {
        var beerListViewController: BeerListViewController = self.storyboard?.instantiateViewControllerWithIdentifier("BeerListViewController") as BeerListViewController
        
        self.presentViewController(beerListViewController, animated: true, completion: nil)
    }
    
    
    @IBAction func directionButtonTapped(sender: AnyObject) {
        var nearbyViewController: NearbyViewController = self.storyboard?.instantiateViewControllerWithIdentifier("NearbyViewController") as NearbyViewController
        
        self.presentViewController(nearbyViewController, animated: true, completion: nil)
    }
    
    
    @IBAction func suggestionButtonTapped(sender: AnyObject) {
        var sViewController: SuggestionViewController = self.storyboard?.instantiateViewControllerWithIdentifier("SuggestionViewController") as SuggestionViewController
        
        self.presentViewController(sViewController, animated: true, completion: nil)
    }
    
    /*
    // ** Needs to change variable name for receiving view controller accordingly. 
    // this fucntion is needed when we need clicking/selecting the cell to move to other views work
    func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
        let user = arrayOfUsers[indexPath.row]
        var postRatingViewController: PostRatingVeiwController = self.storyboard?.instantiateViewControllerWithIdentifier("PostRatingViewController") as PostRatingViewController
        
        postRatingViewController.barbeerString = "bar review"
        //detailedViewController.usernameString = user.username
        //detailedViewController.reviewString = user.review
    
        self.presentViewController(postRatingViewController, animated: true, completion: nil)
        
    }
    */
    
   
    @IBAction func backButtonPressed(sender: AnyObject) {
        //self.dismissViewControllerAnimated(true, completion: nil);
        
        var hViewController: homeViewController = self.storyboard?.instantiateViewControllerWithIdentifier("homeViewController") as homeViewController
        
        self.presentViewController(hViewController, animated: true, completion: nil)
    }

}
