//
//  BeerListViewController.swift
//  BTap
//
//  Created by Chris Ki on 4/1/15.
//  Copyright (c) 2015 Jennifer Wang. All rights reserved.
//

import UIKit

class BeerListViewController: UIViewController, UITableViewDataSource, UITableViewDelegate {
    
    // ctrl+dragged from tableview
    @IBOutlet weak var beerListTableView: UITableView!
    
    var arrayOfBeers: [Beer] = [Beer]()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        // ***
        self.setUpUsers()
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    // load the different beers to the arrayOfBeers
    func setUpUsers() {
        
        var beer1 = Beer(beername: "Double Sunshine", beerDescription: "Amber Ale")
        var beer2 = Beer(beername: "Grey Monday", beerDescription: "English Pale Ale")
        var beer3 = Beer(beername: "Haze", beerDescription: "Saison")
        var beer4 = Beer(beername: "Bourbon County", beerDescription: "American Double")
        var beer5 = Beer(beername: "Ephraim", beerDescription: "Rye Beer")
        var beer6 = Beer(beername: "Julius", beerDescription: "Imperial Double")
        
        arrayOfBeers.append(beer1)
        arrayOfBeers.append(beer2)
        arrayOfBeers.append(beer3)
        arrayOfBeers.append(beer4)
        arrayOfBeers.append(beer5)
        arrayOfBeers.append(beer6)
    }
    
    // number of cells
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arrayOfBeers.count
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell: BeerListCell = tableView.dequeueReusableCellWithIdentifier("BeerCell") as BeerListCell
        
        let beer = arrayOfBeers[indexPath.row]
        // check out Beer.swift and BeerListCell.swift for correct variable names
        cell.setCell(beer.beername)
        
        return cell
    }
    
    // ** Needs to change variable name for receiving view controller accordingly.
    // this fucntion is needed when we need clicking/selecting the cell to move to other views work
    func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
        
        let beer = arrayOfBeers[indexPath.row]
        
        var beerReviewViewController: BeerReviewViewController = self.storyboard?.instantiateViewControllerWithIdentifier("BeerReviewViewController") as BeerReviewViewController
        
        beerReviewViewController.beerNameTitleString = beer.beername
        beerReviewViewController.beerDescriptionString = beer.beerDescription
        
        
        self.presentViewController(beerReviewViewController, animated: true, completion: nil)
        
    }

    @IBAction func BackButtonTapped(sender: AnyObject) {
        //self.dismissViewControllerAnimated(true, completion: nil)
        
        var barReviewViewController: BarReviewViewController = self.storyboard?.instantiateViewControllerWithIdentifier("BarReviewViewController") as BarReviewViewController
        
        self.presentViewController(barReviewViewController, animated: true, completion: nil)
    }
    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */

}
