//
//  BeerReviewViewController.swift
//  BTap
//
//  Created by Chris Ki on 4/1/15.
//  Copyright (c) 2015 Jennifer Wang. All rights reserved.
//

import UIKit

class BeerReviewViewController: UIViewController, UITableViewDataSource, UITableViewDelegate {
    
    @IBOutlet weak var beerReviewTableView: UITableView!
    
    // data for these two come from BeerListView array
    @IBOutlet weak var beerDescriptionLabel: UILabel!
    @IBOutlet weak var beerNameTitleLabel: UILabel!
    var beerNameTitleString: String?
    var beerDescriptionString: String?
    
    var arrayOfBeerUsers: [BeerUser] = [BeerUser]()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // two labels
        self.beerNameTitleLabel.text = beerNameTitleString
        self.beerDescriptionLabel.text = beerDescriptionString

        // Do any additional setup after loading the view.
        self.setUpBeerUsers()
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    // load the different users to the array of User
    func setUpBeerUsers() {
        
        var writeReviewStored = NSUserDefaults.standardUserDefaults().stringForKey("writeReview")
        var userNameStored = NSUserDefaults.standardUserDefaults().stringForKey("userName")
        var ratingNumStored = NSUserDefaults.standardUserDefaults().integerForKey("ratingNum")
        
        // ** change string inside arrays to NSUserDefault variables to make cells (NSUserDefaults will come from PostRatingView's slider and textreview
        var user1 = BeerUser(username: "OdaveO", review: "pretty meh", rating: 2)
        var user2 = BeerUser(username: "Liz35", review: "taste is pretty good", rating: 4)
        var user3 = BeerUser(username: "Michael", review: "I can make it better", rating: 1)
        //
        var user4 = BeerUser(username: userNameStored!, review: writeReviewStored!, rating: ratingNumStored)
        
        arrayOfBeerUsers.append(user1)
        arrayOfBeerUsers.append(user2)
        arrayOfBeerUsers.append(user3)
        //
        arrayOfBeerUsers.append(user4)
    }
    
    // number of cells
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arrayOfBeerUsers.count
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell: BeerReviewCell = tableView.dequeueReusableCellWithIdentifier("BeerReviewCell") as BeerReviewCell
        
        
        let beeruser = arrayOfBeerUsers[indexPath.row]
        // check out BeerUser.swift and BeerReviewCell.swift for correct variable names
        cell.setCell(beeruser.username, reviewLabelText: beeruser.review, ratingLabelInt: beeruser.rating)
        
        
        return cell
    }
    
    @IBAction func writeReviewButtonTapped(sender: AnyObject) {
        var postratingViewController: PostRatingViewController = self.storyboard?.instantiateViewControllerWithIdentifier("PostRatingViewController") as PostRatingViewController
        
        self.presentViewController(postratingViewController, animated: true, completion: nil)
    }
    
    
    @IBAction func backButtonTapped(sender: AnyObject) {
        // .dismissViewController won't do anymore since I can't use dismissViewController for PostRatingView
        //self.dismissViewControllerAnimated(true, completion: nil)
        
        var beerListViewController: BeerListViewController = self.storyboard?.instantiateViewControllerWithIdentifier("BeerListViewController") as BeerListViewController
        
        self.presentViewController(beerListViewController, animated: true, completion: nil)
    }
    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */

}
