//
//  FavViewController.swift
//  BTap
//
//  Created by Chris Ki on 3/17/15.
//  Copyright (c) 2015 Jennifer Wang. All rights reserved.
//

import UIKit

class FavViewController: UIViewController, UITableViewDataSource, UITableViewDelegate {

    @IBOutlet weak var favTableView: UITableView!
    
    var arrayOfFavs: [Fav] = [Fav]()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // ***
        self.setUpUsers()

        // Do any additional setup after loading the view.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    // load the different itemname to the arrayOfFavs
    // names have beer names (fav view lists beers only for now)
    func setUpUsers() {
        
        
        var fav1 = Fav(itemname: "Double Sunshine", itemaddress: "3200 S. Jordan", itemphone: "812-534-0985")
        var fav2 = Fav(itemname: "Grey Monday", itemaddress: "3420 N. 10th Street", itemphone: "812-254-2164")
        var fav3 = Fav(itemname: "Haze", itemaddress: "2300 E. Woodburn", itemphone: "812-854-9724")
        
        arrayOfFavs.append(fav1)
        arrayOfFavs.append(fav2)
        arrayOfFavs.append(fav3)
    }
    
    // number of cells
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arrayOfFavs.count
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell: FavCell = tableView.dequeueReusableCellWithIdentifier("favCell") as FavCell
        
        let fav = arrayOfFavs[indexPath.row]
        // check out Beer.swift and BeerListCell.swift for correct variable names
        cell.setCell(fav.itemname)
        
        return cell
    }
    //
    func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
        
        let bar = arrayOfFavs[indexPath.row]
        
        var barReviewViewController: BarReviewViewController = self.storyboard?.instantiateViewControllerWithIdentifier("BarReviewViewController") as BarReviewViewController
        
        barReviewViewController.barnameTitleString = bar.itemname
        barReviewViewController.barAddressString = bar.itemaddress
        barReviewViewController.barPhoneNumString = bar.itemphone
        
        
        self.presentViewController(barReviewViewController, animated: true, completion: nil)
        
    }
    
    
    
    @IBAction func FavButtonTapped(sender: AnyObject) {
        self.performSegueWithIdentifier("favToFav", sender: self);
    }
    
    @IBAction func NearbyButtonTapped(sender: AnyObject) {
        self.performSegueWithIdentifier("favToNearby", sender: self);
    }
    
    @IBAction func HomeButtonTapped(sender: AnyObject) {
        self.performSegueWithIdentifier("favToHome", sender: self);
    }
    
    @IBAction func SearchButtonTapped(sender: AnyObject) {
        self.performSegueWithIdentifier("favToSearch", sender: self);
    }
    
    @IBAction func ProfileButtonTapped(sender: AnyObject) {
        self.performSegueWithIdentifier("favToProfile", sender: self);
    }
    

    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */

}
