//
//  NearbyViewController.swift
//  BTap
//
//  Created by Chris Ki on 3/17/15.
//  Copyright (c) 2015 Jennifer Wang. All rights reserved.
//

import UIKit
import MapKit

class NearbyViewController: UIViewController, MKMapViewDelegate, CLLocationManagerDelegate {
    
    @IBOutlet weak var mapView: MKMapView!
    
    var locationManager = CLLocationManager()
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        var location = CLLocationCoordinate2D(
            latitude: 39.16,
            longitude: -86.53
        )
        
        var span = MKCoordinateSpanMake(0.5, 0.5)
        var region = MKCoordinateRegion(center: location, span: span)
        
        mapView.setRegion(region, animated: true)
        
        var annotation = MKPointAnnotation()
        annotation.setCoordinate(location)
        annotation.title = "Bloomington"
        annotation.subtitle = "Indiana"
        
        mapView.addAnnotation(annotation)
    }
    // Do any additional setup after loading the view
    /*self.locationManager.delegate = self
    self.locationManager.desiredAccuracy = kCLLocationAccuracyBest
    self.locationManager.requestWhenInUseAuthorization()
    
    self.mapView.showsUserLocation = true
    self.mapView.delegate = self;
    self.mapView.setUserTrackingMode(MKUserTrackingMode.Follow, animated: true);
    */
    
    
    
    @IBAction func zoomIn(sender: AnyObject) {
        let userLocation = mapView.userLocation
        
        let region = MKCoordinateRegionMakeWithDistance(
            userLocation.location.coordinate, 1, 1)
        
        mapView.setRegion(region, animated: true)
    }
    
    
    
    
    @IBAction func changeMapType(sender: AnyObject) {
        if mapView.mapType == MKMapType.Standard {
            mapView.mapType = MKMapType.Satellite
        } else {
            mapView.mapType = MKMapType.Standard
        }
    }
    
    
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    
    @IBAction func FavButtonTapped(sender: AnyObject) {
        self.performSegueWithIdentifier("nearbyToFav", sender: self);
    }
    
    @IBAction func NearbyButtonTapped(sender: AnyObject) {
        self.performSegueWithIdentifier("nearbyToNearby", sender: self);
    }
    
    @IBAction func HomeButtonTapped(sender: AnyObject) {
        self.performSegueWithIdentifier("nearbyToHome", sender: self);
    }
    
    @IBAction func SearchButtonTapped(sender: AnyObject) {
        self.performSegueWithIdentifier("nearbyToSearch", sender: self);
    }
    
    @IBAction func ProfileButtonTapped(sender: AnyObject) {
        self.performSegueWithIdentifier("nearbyToProfile", sender: self);
    }
    
    /*
    // MARK: - Navigation
    
    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
    // Get the new view controller using segue.destinationViewController.
    // Pass the selected object to the new view controller.
    }
    */
    
}
