//
//  PostRatingViewController.swift
//  BTap
//
//  Created by Chris Ki on 3/28/15.
//  Copyright (c) 2015 Jennifer Wang. All rights reserved.
//

import UIKit

class PostRatingViewController: UIViewController {
    

    @IBOutlet weak var displayRatingLabel: UILabel!
    
    @IBOutlet weak var writeReviewTextView: UITextView!
    
    var barbeerString: String?
    
    
    override func viewDidLoad() {
        super.viewDidLoad()

        displayRatingLabel.text = "Move slider to rate from 1 to 5!"
        
        writeReviewTextView.text = "Write a Review:"
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    

    @IBAction func sliderChanged(sender: UISlider) {
        
        // first line retrieves the current value of the slider, rounds it to the nearest integer, and assigns it to an integer variable.
        // second line creates a string containing that number and assigns it to the label.
        let ratingNum = lroundf(sender.value)
        displayRatingLabel.text = "Rating: \(ratingNum)"
        
        // save ratingNum data locally
        // *NOTE: I had to put this here instead of inside the postButtonTapped function, because 'ratingNum' isn't a global variable.
        NSUserDefaults.standardUserDefaults().setInteger(ratingNum, forKey:"ratingNum"); // .setInteger() for int value. not setObject()
        
        NSUserDefaults.standardUserDefaults().synchronize();
    } // sliderChanged ends
    
    
    @IBAction func postButtonTapped(sender: AnyObject) {
        
        let writeReview = writeReviewTextView.text
        
        // this will have to do, since UITextView doesn't support placeholder text option like text field does.
        if (writeReview == "Write a Review:") {
            displayMyAlertMessage("review field cannot be empty!")
            return
        }
            // check if user didn't move around the slider
        else if (displayRatingLabel.text == "Move slider to rate from 1 to 5!") {
            displayMyAlertMessage("You didn't leave the rating!")
            return
        }
        else {
            
            // saving "text review" locally
            NSUserDefaults.standardUserDefaults().setObject(writeReview, forKey:"writeReview");
            
            NSUserDefaults.standardUserDefaults().synchronize();
            
            //self.performSegueWithIdentifier("postToView2", sender: self);
            
            // this will close the Post Rating View and go back to the previous page
            //self.dismissViewControllerAnimated(true, completion:nil);
            var beerReviewViewController: BeerReviewViewController = self.storyboard?.instantiateViewControllerWithIdentifier("BeerReviewViewController") as BeerReviewViewController
            
            self.presentViewController(beerReviewViewController, animated: true, completion: nil)
        }

    } // postButtonTapped ends
    
    @IBAction func cancelButtonTapped(sender: AnyObject) {
        self.dismissViewControllerAnimated(true, completion:nil);
    }
    
    
    func displayMyAlertMessage(userMessage:String) {
        
        var myAlert = UIAlertController(title:"Alert", message: userMessage, preferredStyle: UIAlertControllerStyle.Alert);
        
        // ok button
        let okAction = UIAlertAction(title:"Ok", style: UIAlertActionStyle.Default, handler:nil);
        
        myAlert.addAction(okAction);
        
        self.presentViewController(myAlert, animated:true, completion:nil);
    } // display function ends

} // class ends
