//
//  SearchViewController.swift
//  BTap
//
//  Created by Chris Ki on 3/19/15.
//  Copyright (c) 2015 Jennifer Wang. All rights reserved.
//

import UIKit
import Foundation

class SearchViewController: UIViewController, UITableViewDelegate {
    
    @IBOutlet var userQueryTextField: UITextField!
    
    @IBOutlet weak var tableView: UITableView!
    
    func displayMyAlertMessage(userMessage:String) {
        
        var myAlert = UIAlertController(title:"Alert", message: userMessage, preferredStyle: UIAlertControllerStyle.Alert);
        
        // ok button
        let okAction = UIAlertAction(title:"Ok", style: UIAlertActionStyle.Default, handler:nil);
        
        myAlert.addAction(okAction);
        
        self.presentViewController(myAlert, animated:true, completion:nil);
    }
    
    

    //func JSONStringify(value: AnyObject, prettyPrinted: Bool = False) -> String
    
    /*
    let textCellIdentifier = "TextCell"
    
    let resultValue = [""]
    */
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        //tableView.delegate = self
        //tableView.dataSource = self
    }


    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    
    //func JSONParseArray(jsonString: String) ->
    /*
    func numberOfSectionsInTableView(tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(tableView: UITableView, numberofRowsInSection section: Int) -> Int {
        return resultValue.count
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCellWithIdentifier(textCellIdentifier, forIndexPath: indexPath) as UITableViewCell
        
        let row = indexPath.row
        cell.textLabel?.text = resultValue[row]
        
        return cell
    }
    
    func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
        tableView.deselectRowAtIndexPath(indexPath, animated: true)
        
        let row = indexPath.row
        println(resultValue[row])
    }
    */

    @IBAction func FavButtonTapped(sender: AnyObject) {
        self.performSegueWithIdentifier("searchToFav", sender: self);
    }
    
    @IBAction func NearbyButtonTapped(sender: AnyObject) {
        self.performSegueWithIdentifier("searchToNearby", sender: self);
    }
    
    @IBAction func HomeButtonTapped(sender: AnyObject) {
        self.performSegueWithIdentifier("searchToHome", sender: self);
    }
    
    @IBAction func SearchButtonTapped(sender: AnyObject) {
        self.performSegueWithIdentifier("searchToSearch", sender: self);
    }
    
    @IBAction func ProfileButtonTapped(sender: AnyObject) {
        self.performSegueWithIdentifier("searchToProfile", sender: self);
    }

    
    @IBAction func searchButtonTapped(sender: AnyObject) {
        
        let userQuery = userQueryTextField.text;
        
        if (userQuery.isEmpty) {
            displayMyAlertMessage("Please enter a search term.");
            return;
        }
        
        let myUrl = NSURL(string: "http://cgi.soic.indiana.edu/~team3/searchBeer.php");
        let request = NSMutableURLRequest(URL:myUrl!);
        request.HTTPMethod = "POST";
        
        let postString = "query=\(userQuery)";
        
        request.HTTPBody = postString.dataUsingEncoding(NSUTF8StringEncoding);
        
        let task = NSURLSession.sharedSession().dataTaskWithRequest(request) {
            data, response, error in
            
            if error != nil {
                println("error=\(error)")
                return
            }
            
            var error: NSError?
            var json = NSJSONSerialization.JSONObjectWithData(data, options: .MutableContainers, error: &error) as? NSArray
            
            //if let queryRows = json {
            //    let resultValue:Array = queryRows as Array!;
            //    println("result: \(resultValue)")
                
            //} else {
            //    println("parse error: \(error)")
            //}
            
        }
        
        task.resume()
        
    }

    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */

}
