//
//  SuggestionViewController.swift
//  BTap
//
//  Created by Chris Ki on 4/3/15.
//  Copyright (c) 2015 Jennifer Wang. All rights reserved.
//

import UIKit

class SuggestionViewController: UIViewController {

    @IBOutlet weak var suggestionTextView: UITextView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        suggestionTextView.text = "write suggestion:"

        // Do any additional setup after loading the view.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
   

    @IBAction func cancelButtonTapped(sender: AnyObject) {
        self.dismissViewControllerAnimated(true, completion:nil);
        
    }
    
    
    @IBAction func sentButtonTapped(sender: AnyObject) {
        let writeSuggestion = suggestionTextView.text
        
        // this will have to do, since UITextView doesn't support placeholder text option like text field does.
        if (writeSuggestion == "Sugesstion...") {
            displayMyAlertMessage("review field cannot be empty!")
            return
        }
        else {
            
            // saving "text review" locally
            NSUserDefaults.standardUserDefaults().setObject(writeSuggestion, forKey:"writeSuggestion");
            
            NSUserDefaults.standardUserDefaults().synchronize();
            
            //self.performSegueWithIdentifier("postToView2", sender: self);
            
            // this will close the Post Rating View and go back to the previous page
            self.dismissViewControllerAnimated(true, completion:nil);
        }
    }
    
    func displayMyAlertMessage(userMessage:String) {
        
        var myAlert = UIAlertController(title:"Alert", message: userMessage, preferredStyle: UIAlertControllerStyle.Alert);
        
        // ok button
        let okAction = UIAlertAction(title:"Ok", style: UIAlertActionStyle.Default, handler:nil);
        
        myAlert.addAction(okAction);
        
        self.presentViewController(myAlert, animated:true, completion:nil);
    } // display function ends

}
